﻿{ !NAME:      FEX CLI Filter }
{ !DESC:      Filter files }
{ !AUTHOR:    GetData }

uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  theFileDriverInfo: TFileTypeInformation;
begin
  Result := -1; // Exclude

  if assigned(anEntry) then
  begin
    // By Signature
    theFileDriverInfo := anEntry.DeterminedFileDriverInfo;
    if theFileDriverInfo.ShortDisplayName = 'Crypto Wallet' then //noslz
      Result := 1; // Include

    // By Filename
    if (Result = -1) and (not (anEntry.isSystem)) and (not (anEntry.isDirectory)) then
    begin
      if RegexMatch(anEntry.EntryName, '^Wallet', False) or // noslz
      RegexMatch(anEntry.Extension, '\.wallet', false) then // noslz
      begin
        Result := 1; // Include
      end;
    end;
  end;

end;

begin

end.
